/*
 *  Compex WPJ72 board support
 *
 *  Copyright (C) 2008-2009 Gabor Juhos <juhosg@openwrt.org>
 *  Copyright (C) 2008 Imre Kaloz <kaloz@openwrt.org>
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License version 2 as published
 *  by the Free Software Foundation.
 */

#include <linux/mtd/mtd.h>
#include <linux/mtd/partitions.h>

#include <asm/mach-ar71xx/ar71xx.h>

#include "machtype.h"
#include "devices.h"
#include "dev-m25p80.h"
#include "dev-pb9x-pci.h"
#include "dev-gpio-buttons.h"
#include "dev-leds-gpio.h"

#define WPJ72_GPIO_LED_LAN1		0
#define WPJ72_GPIO_LED_LAN2		1
#define WPJ72_GPIO_SW1			12
#define WPJ72_GPIO_LED_DIAG		13
#define WPJ72_GPIO_LED_SIG1		14
#define WPJ72_GPIO_LED_SIG2		15
#define WPJ72_GPIO_LED_SIG3		16
#define WPJ72_GPIO_LED_SIG4		17

#define WPJ72_BUTTONS_POLL_INTERVAL	20

static struct gpio_led wpj72_leds_gpio[] __initdata = {
	{
		.name		= "wpj72_green_lan1",
		.gpio		= WPJ72_GPIO_LED_LAN1,
		.active_low	= 1,
	}, {
		.name		= "wpj72_green_lan2",
		.gpio		= WPJ72_GPIO_LED_LAN2,
		.active_low	= 1,
	}, {
		.name		= "wpj72_green_diag",
		.gpio		= WPJ72_GPIO_LED_DIAG,
		.active_low	= 1,
	}, {
		.name		= "wpj72_red_sig1",
		.gpio		= WPJ72_GPIO_LED_SIG1,
		.active_low	= 1,
	}, {
		.name		= "wpj72_yellow_sig2",
		.gpio		= WPJ72_GPIO_LED_SIG2,
		.active_low	= 1,
	}, {
		.name		= "wpj72_green_sig3",
		.gpio		= WPJ72_GPIO_LED_SIG3,
		.active_low	= 1,
	}, {
		.name		= "wpj72_green_sig4",
		.gpio		= WPJ72_GPIO_LED_SIG4,
		.active_low	= 1,
	}
};

static struct gpio_button wpj72_gpio_buttons[] __initdata = {
	{
		.desc		= "sw1",
		.type		= EV_KEY,
		.code		= BTN_0,
		.threshold	= 3,
		.gpio		= WPJ72_GPIO_SW1,
	}
};

static void __init wpj72_setup(void)
{
	ar71xx_add_device_m25p80(NULL);

	ar71xx_add_device_mdio(~0x18);
	ar71xx_eth0_data.phy_if_mode = PHY_INTERFACE_MODE_MII;
	ar71xx_eth0_data.phy_mask = 0x10;
	ar71xx_eth0_data.fifo_cfg1 = 0x0010FFFF;
	ar71xx_eth0_data.fifo_cfg2 = 0x015500AA;
	ar71xx_eth0_data.fifo_cfg3 = 0x01F00140;

	ar71xx_eth1_data.phy_if_mode = PHY_INTERFACE_MODE_RMII;
	ar71xx_eth1_data.phy_mask = 0x08;
	ar71xx_eth1_data.is_fixed = 1;
	ar71xx_eth1_data.speed = SPEED_1000;
	ar71xx_eth1_data.duplex = DUPLEX_FULL;
	ar71xx_eth1_data.fifo_cfg1 = 0x0010FFFF;
	ar71xx_eth1_data.fifo_cfg2 = 0x015500AA;
	ar71xx_eth1_data.fifo_cfg3 = 0x01F00140;

	ar71xx_add_device_eth(0);
	ar71xx_add_device_eth(1);

	pb9x_pci_init();

	ar71xx_add_device_leds_gpio(-1, ARRAY_SIZE(wpj72_leds_gpio),
					wpj72_leds_gpio);

	ar71xx_add_device_gpio_buttons(-1, WPJ72_BUTTONS_POLL_INTERVAL,
					ARRAY_SIZE(wpj72_gpio_buttons),
					wpj72_gpio_buttons);
}

MIPS_MACHINE(AR71XX_MACH_WPJ72, "WPJ72", "Compex WPJ72", wpj72_setup);
